/******************************************************************************

  Copyright (c) 2013-2017, Intel Corporation 
  All rights reserved.
  
  Redistribution and use in source and binary forms, with or without 
  modification, are permitted provided that the following conditions are met:
  
   1. Redistributions of source code must retain the above copyright notice, 
      this list of conditions and the following disclaimer.
  
   2. Redistributions in binary form must reproduce the above copyright 
      notice, this list of conditions and the following disclaimer in the 
      documentation and/or other materials provided with the distribution.
  
   3. Neither the name of the Intel Corporation nor the names of its 
      contributors may be used to endorse or promote products derived from 
      this software without specific prior written permission.
  
  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
  ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
  POSSIBILITY OF SUCH DAMAGE.

******************************************************************************/
/*$FreeBSD$*/


#ifndef _IAVF_H_
#define _IAVF_H_

#include "iavf_vc_mgr.h"

#define IAVF_AQ_MAX_ERR		30
#define IAVF_MAX_INIT_WAIT	120
#define IAVF_MAX_FILTERS	128
#define IAVF_MAX_QUEUES		16
#define IAVF_AQ_TIMEOUT		(1 * hz)
#define IAVF_CALLOUT_TIMO	(hz / 50)	/* 20 msec */

#define IAVF_FLAG_AQ_ENABLE_QUEUES            (u32)(1 << 0)
#define IAVF_FLAG_AQ_DISABLE_QUEUES           (u32)(1 << 1)
#define IAVF_FLAG_AQ_ADD_MAC_FILTER           (u32)(1 << 2)
#define IAVF_FLAG_AQ_ADD_VLAN_FILTER          (u32)(1 << 3)
#define IAVF_FLAG_AQ_DEL_MAC_FILTER           (u32)(1 << 4)
#define IAVF_FLAG_AQ_DEL_VLAN_FILTER          (u32)(1 << 5)
#define IAVF_FLAG_AQ_CONFIGURE_QUEUES         (u32)(1 << 6)
#define IAVF_FLAG_AQ_MAP_VECTORS              (u32)(1 << 7)
#define IAVF_FLAG_AQ_HANDLE_RESET             (u32)(1 << 8)
#define IAVF_FLAG_AQ_CONFIGURE_PROMISC        (u32)(1 << 9)
#define IAVF_FLAG_AQ_GET_STATS                (u32)(1 << 10)
#define IAVF_FLAG_AQ_CONFIG_RSS_KEY           (u32)(1 << 11)
#define IAVF_FLAG_AQ_SET_RSS_HENA             (u32)(1 << 12)
#define IAVF_FLAG_AQ_GET_RSS_HENA_CAPS        (u32)(1 << 13)
#define IAVF_FLAG_AQ_CONFIG_RSS_LUT          (u32)(1 << 14)

/* printf %b arg */
#define IAVF_FLAGS \
    "\20\1ENABLE_QUEUES\2DISABLE_QUEUES\3ADD_MAC_FILTER" \
    "\4ADD_VLAN_FILTER\5DEL_MAC_FILTER\6DEL_VLAN_FILTER" \
    "\7CONFIGURE_QUEUES\10MAP_VECTORS\11HANDLE_RESET" \
    "\12CONFIGURE_PROMISC\13GET_STATS"
#define IAVF_PRINTF_VF_OFFLOAD_FLAGS \
    "\20\1I40E_VIRTCHNL_VF_OFFLOAD_L2" \
    "\2I40E_VIRTCHNL_VF_OFFLOAD_IWARP" \
    "\3I40E_VIRTCHNL_VF_OFFLOAD_FCOE" \
    "\4I40E_VIRTCHNL_VF_OFFLOAD_RSS_AQ" \
    "\5I40E_VIRTCHNL_VF_OFFLOAD_RSS_REG" \
    "\6I40E_VIRTCHNL_VF_OFFLOAD_WB_ON_ITR" \
    "\21I40E_VIRTCHNL_VF_OFFLOAD_VLAN" \
    "\22I40E_VIRTCHNL_VF_OFFLOAD_RX_POLLING" \
    "\23I40E_VIRTCHNL_VF_OFFLOAD_RSS_PCTYPE_V2" \
    "\24I40E_VIRTCHNL_VF_OFFLOAD_RSS_PF"

/* Driver state */
enum iavf_state_t {
	IAVF_START,
	IAVF_FAILED,
	IAVF_RESET_REQUIRED,
	IAVF_RESET_PENDING,
	IAVF_VERSION_CHECK,
	IAVF_GET_RESOURCES,
	IAVF_INIT_READY,
	IAVF_INIT_START,
	IAVF_INIT_CONFIG,
	IAVF_INIT_MAPPING,
	IAVF_INIT_ENABLE,
	IAVF_INIT_COMPLETE,
	IAVF_RUNNING,
};

/* Structs */

struct iavf_mac_filter {
	SLIST_ENTRY(iavf_mac_filter)  next;
	u8      macaddr[ETHER_ADDR_LEN];
	u16     flags;
};
SLIST_HEAD(mac_list, iavf_mac_filter);

struct iavf_vlan_filter {
	SLIST_ENTRY(iavf_vlan_filter)  next;
	u16     vlan;
	u16     flags;
};
SLIST_HEAD(vlan_list, iavf_vlan_filter);

/* Software controller structure */
struct iavf_sc {
	struct i40e_hw		hw;
	struct i40e_osdep	osdep;
	struct device		*dev;

	struct resource		*pci_mem;
	struct resource		*msix_mem;

	enum iavf_state_t	init_state;
	int			init_in_progress;

	/*
	 * Interrupt resources
	 */
	void			*tag;
	struct resource 	*res; /* For the AQ */

	struct ifmedia		media;
	struct callout		timer;
	int			msix;
	int			pf_version;
	int			if_flags;

	bool				link_up;
	enum virtchnl_link_speed	link_speed;

	struct mtx		mtx;

	u32 			admvec;
	struct timeout_task	timeout;
	struct task     	aq_irq;
	struct task     	aq_sched;
	struct taskqueue	*tq;

	struct ixl_vsi		vsi;

	/* Filter lists */
	struct mac_list		*mac_filters;
	struct vlan_list	*vlan_filters;

	/* Promiscuous mode */
	u32			promiscuous_flags;

	/* Admin queue task flags */
	u32			aq_wait_count;

	struct ixl_vc_mgr	vc_mgr;
	struct ixl_vc_cmd	add_mac_cmd;
	struct ixl_vc_cmd	del_mac_cmd;
	struct ixl_vc_cmd	config_queues_cmd;
	struct ixl_vc_cmd	map_vectors_cmd;
	struct ixl_vc_cmd	enable_queues_cmd;
	struct ixl_vc_cmd	add_vlan_cmd;
	struct ixl_vc_cmd	del_vlan_cmd;
	struct ixl_vc_cmd	add_multi_cmd;
	struct ixl_vc_cmd	del_multi_cmd;

	struct ixl_vc_cmd	config_rss_key_cmd;
	struct ixl_vc_cmd	get_rss_hena_caps_cmd;
	struct ixl_vc_cmd	set_rss_hena_cmd;
	struct ixl_vc_cmd	config_rss_lut_cmd;

	/* Virtual comm channel */
	struct virtchnl_vf_resource *vf_res;
	struct virtchnl_vsi_resource *vsi_res;

	/* Misc stats maintained by the driver */
	u64			watchdog_events;
	u64			admin_irq;

	u8			aq_buffer[IXL_AQ_BUF_SZ];
};

#define IAVF_CORE_LOCK_ASSERT(sc)	mtx_assert(&(sc)->mtx, MA_OWNED)
/*
** This checks for a zero mac addr, something that will be likely
** unless the Admin on the Host has created one.
*/
static inline bool
iavf_check_ether_addr(u8 *addr)
{
	bool status = TRUE;

	if ((addr[0] == 0 && addr[1]== 0 && addr[2] == 0 &&
	    addr[3] == 0 && addr[4]== 0 && addr[5] == 0))
		status = FALSE;
	return (status);
}

/*
** VF Common function prototypes
*/
int	iavf_send_api_ver(struct iavf_sc *);
int	iavf_verify_api_ver(struct iavf_sc *);
int	iavf_send_vf_config_msg(struct iavf_sc *);
int	iavf_get_vf_config(struct iavf_sc *);
void	iavf_init(void *);
int	iavf_reinit_locked(struct iavf_sc *);
void	iavf_configure_queues(struct iavf_sc *);
void	iavf_enable_queues(struct iavf_sc *);
void	iavf_disable_queues(struct iavf_sc *);
void	iavf_map_queues(struct iavf_sc *);
void	iavf_enable_intr(struct ixl_vsi *);
void	iavf_disable_intr(struct ixl_vsi *);
void	iavf_add_ether_filters(struct iavf_sc *);
void	iavf_del_ether_filters(struct iavf_sc *);
void	iavf_request_stats(struct iavf_sc *);
void	iavf_request_reset(struct iavf_sc *);
void	iavf_vc_completion(struct iavf_sc *,
	enum virtchnl_ops, enum virtchnl_status_code,
	u8 *, u16);
void	iavf_add_ether_filter(struct iavf_sc *);
void	iavf_add_vlans(struct iavf_sc *);
void	iavf_del_vlans(struct iavf_sc *);
void	iavf_update_stats_counters(struct iavf_sc *,
		    struct i40e_eth_stats *);
void	iavf_update_link_status(struct iavf_sc *);
void	iavf_get_default_rss_key(u32 *, bool);
void	iavf_config_rss_key(struct iavf_sc *);
void	iavf_set_rss_hena(struct iavf_sc *);
void	iavf_config_rss_lut(struct iavf_sc *);

#endif /* _IAVF_H_ */
